<?php
    global $VISUAL_COMPOSER_EXTENSIONS;

    function TS_VCSC_FileGetCurlError($error) {
        $curl_codes = array (
            0 => 'CURLE_OK',
            1 => 'CURLE_UNSUPPORTED_PROTOCOL',
            2 => 'CURLE_FAILED_INIT',
            3 => 'CURLE_URL_MALFORMAT',
            4 => 'CURLE_NOT_BUILT_IN',
            5 => 'CURLE_COULDNT_RESOLVE_PROXY',
            6 => 'CURLE_COULDNT_RESOLVE_HOST',
            7 => 'CURLE_COULDNT_CONNECT',
            8 => 'CURLE_FTP_WEIRD_SERVER_REPLY',
            9 => 'CURLE_REMOTE_ACCESS_DENIED',
            10 => 'CURLE_FTP_ACCEPT_FAILED',
            11 => 'CURLE_FTP_WEIRD_PASS_REPLY',
            12 => 'CURLE_FTP_ACCEPT_TIMEOUT',
            13 => 'CURLE_FTP_WEIRD_PASV_REPLY',
            14 => 'CURLE_FTP_WEIRD_227_FORMAT',
            15 => 'CURLE_FTP_CANT_GET_HOST',
            17 => 'CURLE_FTP_COULDNT_SET_TYPE',
            18 => 'CURLE_PARTIAL_FILE',
            19 => 'CURLE_FTP_COULDNT_RETR_FILE',
            21 => 'CURLE_QUOTE_ERROR',
            22 => 'CURLE_HTTP_RETURNED_ERROR',
            23 => 'CURLE_WRITE_ERROR',
            25 => 'CURLE_UPLOAD_FAILED',
            26 => 'CURLE_READ_ERROR',
            27 => 'CURLE_OUT_OF_MEMORY',
            28 => 'CURLE_OPERATION_TIMEDOUT',
            30 => 'CURLE_FTP_PORT_FAILED',
            31 => 'CURLE_FTP_COULDNT_USE_REST',
            33 => 'CURLE_RANGE_ERROR',
            34 => 'CURLE_HTTP_POST_ERROR',
            35 => 'CURLE_SSL_CONNECT_ERROR',
            36 => 'CURLE_BAD_DOWNLOAD_RESUME',
            37 => 'CURLE_FILE_COULDNT_READ_FILE',
            38 => 'CURLE_LDAP_CANNOT_BIND',
            39 => 'CURLE_LDAP_SEARCH_FAILED',
            41 => 'CURLE_FUNCTION_NOT_FOUND',
            42 => 'CURLE_ABORTED_BY_CALLBACK',
            43 => 'CURLE_BAD_FUNCTION_ARGUMENT',
            45 => 'CURLE_INTERFACE_FAILED',
            47 => 'CURLE_TOO_MANY_REDIRECTS',
            48 => 'CURLE_UNKNOWN_OPTION',
            49 => 'CURLE_TELNET_OPTION_SYNTAX',
            51 => 'CURLE_PEER_FAILED_VERIFICATION',
            52 => 'CURLE_GOT_NOTHING',
            53 => 'CURLE_SSL_ENGINE_NOTFOUND',
            54 => 'CURLE_SSL_ENGINE_SETFAILED',
            55 => 'CURLE_SEND_ERROR',
            56 => 'CURLE_RECV_ERROR',
            58 => 'CURLE_SSL_CERTPROBLEM',
            59 => 'CURLE_SSL_CIPHER',
            60 => 'CURLE_SSL_CACERT',
            61 => 'CURLE_BAD_CONTENT_ENCODING',
            62 => 'CURLE_LDAP_INVALID_URL',
            63 => 'CURLE_FILESIZE_EXCEEDED',
            64 => 'CURLE_USE_SSL_FAILED',
            65 => 'CURLE_SEND_FAIL_REWIND',
            66 => 'CURLE_SSL_ENGINE_INITFAILED',
            67 => 'CURLE_LOGIN_DENIED',
            68 => 'CURLE_TFTP_NOTFOUND',
            69 => 'CURLE_TFTP_PERM',
            70 => 'CURLE_REMOTE_DISK_FULL',
            71 => 'CURLE_TFTP_ILLEGAL',
            72 => 'CURLE_TFTP_UNKNOWNID',
            73 => 'CURLE_REMOTE_FILE_EXISTS',
            74 => 'CURLE_TFTP_NOSUCHUSER',
            75 => 'CURLE_CONV_FAILED',
            76 => 'CURLE_CONV_REQD',
            77 => 'CURLE_SSL_CACERT_BADFILE',
            78 => 'CURLE_REMOTE_FILE_NOT_FOUND',
            79 => 'CURLE_SSH',
            80 => 'CURLE_SSL_SHUTDOWN_FAILED',
            81 => 'CURLE_AGAIN',
            82 => 'CURLE_SSL_CRL_BADFILE',
            83 => 'CURLE_SSL_ISSUER_ERROR',
            84 => 'CURLE_FTP_PRET_FAILED',
            85 => 'CURLE_RTSP_CSEQ_ERROR',
            86 => 'CURLE_RTSP_SESSION_ERROR',
            87 => 'CURLE_FTP_BAD_FILE_LIST',
            88 => 'CURLE_CHUNK_FAILED',
            89 => 'CURLE_NO_CONNECTION_AVAILABLE',
            90 => 'CURLE_SSL_PINNEDPUBKEYNOTMATCH',
            91 => 'CURLE_SSL_INVALIDCERTSTATUS',
            92 => 'CURLE_HTTP2_STREAM',
        );
        return (isset($curl_codes[$error]) ? $curl_codes[$error] : 'N/A');
    }

	function TS_VCSC_FileGetContentsCurl($url, $retries = 5) {
        $ua                     = 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.103 Safari/537.36';
		if (extension_loaded('curl') === true) {
			$ch                 = curl_init();	
			curl_setopt($ch, CURLOPT_URL, $url); 				// The URL to fetch. This can also be set when initializing a session with curl_init().
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE); 	// TRUE to return the transfer as a string of the return value of curl_exec() instead of outputting it out directly.
			curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10); 		// The number of seconds to wait while trying to connect.
			curl_setopt($ch, CURLOPT_USERAGENT, $ua); 			// The contents of the "User-Agent: " header to be used in a HTTP request.
			curl_setopt($ch, CURLOPT_FAILONERROR, TRUE); 		// To fail silently if the HTTP code returned is greater than or equal to 400.
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE); 	// To follow any "Location: " header that the server sends as part of the HTTP header.
			curl_setopt($ch, CURLOPT_AUTOREFERER, TRUE); 		// To automatically set the Referer: field in requests where it follows a Location: redirect.
			curl_setopt($ch, CURLOPT_TIMEOUT, 10); 				// The maximum number of seconds to allow cURL functions to execute.
            curl_setopt($ch, CURLOPT_MAXREDIRS, 5); 			// The maximum number of redirects
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0); 		// Verify the peer's SSL certificate true/false
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0); 		// Verify the certificate's name against host true/false
            $result             = curl_exec($ch);
            $http_status        = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            $curl_errno         = curl_errno($ch);
            if (($curl_errno) && ($retries === 0)) {
                $result         = 'ERROR|CURL Error Code: ' . $curl_errno . '<br/>|CURL Error Info: ' . TS_VCSC_FileGetCurlError($curl_errno) . '<br/>|HTTP Error Code: ' . $http_status . '<br/>|HTTP Error Info: ' . curl_error($ch) . '<br/>';
            }
            curl_close($ch);
		} else {
			$result             = file_get_contents($url);
		}       
		if (empty($result) === true) {
			$result             = false;
			if ($retries >= 1) {
				sleep(1);
				return TS_VCSC_FileGetContentsCurl($url, --$retries);
			}
		}
		return $result;
	}
?>
<div class="ts-vcsc-system-information-wrap wrap" style="width: 100%;">
    <div class="ts-vcsc-settings-group-header">
        <div class="display_header">
            <h2><span class="dashicons dashicons-media-text"></span>Composium - WP Bakery Page Builder Extensions v<?php echo TS_VCSC_GetPluginVersion(); ?> ... Changelog</h2>
        </div>
        <div class="clear"></div>
    </div>
	<div class="ts-vcsc-system-information-main">
        <div class="ts-vcsc-notice-field ts-vcsc-success" style="margin-top: 0px; font-size: 13px; text-align: justify;">
            The plugin is constantly evolving and adding new features. The listing below is a summary of all changes and additions so far.
        </div>
        <?php
            $url_gets		= ini_get('allow_url_fopen');
            $url_site 		= get_site_url();
            $url_file		= TS_VCSC_GetResourceURL('changelog.txt');
            if (strpos($url_file, $url_site) !== false) {
                $url_final	= $url_file;
            } else {
                $url_final	= $url_site . $url_file;
            }
            if ($url_gets == 1) {
                $changelog 		= TS_VCSC_FileGetContentsCurl($url_final, 0);
                if (substr($changelog, 0, 5) === "ERROR") {
                    $changelog  = explode ("|", $changelog);
                    echo 'Your site setup does not allow the changelog file to be loaded and read. You can find the full and official changelog
                    <a href="https://helpdesk.krautcoding.com/changelog-composium-visual-composer-extensions/" target="_blank">here</a>.<br/><br/>';
                    echo 'The following error information have been returned by the server:<br/><br/>';
                    foreach($changelog as $error) {
                        echo $error;
                    }
                } else {
                    echo nl2br(str_replace('<br/>', PHP_EOL, $changelog));
                }
            } else {
                echo 'Your site setup does not allow the usage of "allow_url_fopen" and so the changelog file could not be loaded. You can find the full and official changelog
                <a href="https://helpdesk.krautcoding.com/changelog-composium-visual-composer-extensions/" target="_blank">here</a>.';
            }
        ?>
	</div>
</div>